require "rails_helper"

RSpec.describe Payments::XsollaPlansController do
  include_context "mocked permissions"

  let(:permission) { "xsolla" }

  describe 'index' do
    describe 'permissions' do
      let(:action) { :index }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Payments::XsollaPlan).to receive(:load_plans).and_return([])
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end


  describe 'new' do
    describe 'permissions' do
      let(:action) { :new }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          get action, :params => {
            :payments_xsolla_plan => {
              :group_id => 12345,
              :price => 12345,
              :month_interval => 100
            }
          }
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action, :params => {
            :payments_xsolla_plan => {
              :group_id => 12345,
              :price => 12345,
              :month_interval => 100
            }
          }
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'create' do
    describe 'permissions' do
      let(:action) { :create }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect_any_instance_of(Payments::XsollaPlan).to receive(:save).and_return(true)
          post action, :params => {
            :payments_xsolla_plan => {
              :group_id => 12345,
              :price => 12345,
              :month_interval => 100
            }
          }
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          post action, :params => {
            :payments_xsolla_plan => {
              :group_id => 12345,
              :price => 12345,
              :month_interval => 100
            }
          }
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end
  end
end
