module PayoutEntities
  describe BulkInvitationsController do
    include_context 'mocked permissions'

    describe 'index' do
      let(:action) { 'index' }
      let(:permission) do
        [
          'payout_entities_bulk_invitation_0cpm',
          'payout_entities_bulk_invitation_affiliate',
          'payout_entities_bulk_invitation_partner'
        ]
      end

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

    shared_examples_for 'create' do
      let(:action) { 'create' }
      let(:bulk_invitation) { BulkInvitation.new(user_category: user_category) }
      let(:bulk_invitation_param) { { user_category: user_category } }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(BulkInvitation).to receive(:new)
            .with(ActionController::Parameters.new(bulk_invitation_param))
            .and_return(bulk_invitation)
          expect(bulk_invitation).to receive(:save)
            .with(ldap_login: ldap_name)

          post action, params: {
            payout_entities_bulk_invitation: bulk_invitation_param
          }
        end

        it 'redirects the user for success' do
          expect(response.code).to eq('302')
        end
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          expect(BulkInvitation).to receive(:new)
            .with(ActionController::Parameters.new(bulk_invitation_param))
            .and_return(bulk_invitation)

          post action, params: {
            payout_entities_bulk_invitation: bulk_invitation_param
          }
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

    describe 'create' do
      context '0cpm' do
        let(:user_category) { '0cpm' }
        let(:permission) { 'payout_entities_bulk_invitation_0cpm' }

        it_behaves_like 'create'
      end

      context 'affiliate' do
        let(:user_category) { 'affiliate' }
        let(:permission) { 'payout_entities_bulk_invitation_affiliate' }

        it_behaves_like 'create'
      end

      context 'partner' do
        let(:user_category) { 'partner' }
        let(:permission) { 'payout_entities_bulk_invitation_partner' }

        it_behaves_like 'create'
      end
    end
  end
end
