require 'rails_helper'

RSpec.describe PayoutEntities::WorkflowsController do
  include_context "mocked permissions"

  let(:permission) { "payout_entities" }

  describe '#destroy' do
    include_context "an authorized user"

    subject { delete :destroy, params: params }

    let(:params) do
      {
        id: 1,
        channel_id: channel_id
      }
    end
    let(:channel_id) { '123' }

    before do
      expect(PayoutEntities::Workflow).to receive(:restart)
        .with(channel_id, ldap_login: "cool_ldap_login")
        .and_return(result)
      subject
    end

    context 'with successful restart' do
      let(:result) { true }
      it_behaves_like 'it redirects the user and does not display an error'
    end

    context 'with failed restart' do
      let(:result) { false }
      it_behaves_like 'it redirects the user and displays an error'
    end
  end
end
