module ResqueJobs
  describe WorkersController do
    include_context 'mocked permissions'

    let(:permission) { 'support_tools' }

    describe 'index' do
      let(:action) { :index }

      context 'with permissions' do
        include_context 'an authorized user'

        before(:each) do
          allow(Worker).to receive(:all).and_return([])
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        it 'redirects the user and displays an error' do
          get action
        end
      end
    end
  end
end
