require "rails_helper"

RSpec.describe Subscriptions::BadgeTimeoutStatusesController do
  include_context "mocked permissions"

  let(:channel_id) { 12345 }

  describe "#update" do
    describe "permissions" do
      let(:permission) { "ticket_products" }

      context "a user with appropriate permissions" do
        include_context "an authorized user"

        let(:timeout_status) { Subscriptions::BadgeTimeoutStatus.new }

        let(:patch_data) do
          {
            expires_on: Time.now,
            timed_out: true
          }
        end

        before do
          allow(Subscriptions::BadgeTimeoutStatus).to receive(:find_by).once
            .with(channel_id: channel_id.to_s).and_return(timeout_status)

          allow(timeout_status).to receive(:update).once.and_return(true)

          patch :update, params: { channel_id: channel_id, subscriptions_badge_timeout_status: patch_data }
        end

        it_behaves_like "it redirects the user and displays a success message"
      end

      context "a user without appropriate permissions" do
        include_context "an unauthorized user"

        before do
          patch :update, params: { channel_id: channel_id }
        end

        it_behaves_like "it redirects the user and displays an error"
      end
    end
  end
end
