require "rails_helper"

RSpec.describe Subscriptions::PendingEmoticonPrefixesController do
  include_context "mocked permissions"

  let(:permission) { "ticket_products" }

  describe "#index" do
    let(:ticket_product_id) { 123 }
    let(:limit) { 20 }

    describe "permissions" do
      context "a user with appropriate permissions" do
        include_context "an authorized user"

        before do
          allow(Mako::EmotePrefix).to receive(:get_pending_prefixes).once
            .with(limit).and_return(double([]))
          expect(Mako::EmotePrefix).to receive(:get_pending_prefixes).once

          get :index
        end

        it_behaves_like "it returns a success response"
      end

      context "a user without appropriate permissions" do
        include_context "an unauthorized user"

        before do
          get :index
        end

        it_behaves_like "it redirects the user and displays an error"
      end
    end
  end

  describe "#update" do
    let(:channel_id) { '12345' }
    let(:prefix) { 'myprefix' }
    let(:state) { 'PREFIX_PENDING' }

    describe "permissions" do
      context "a user with appropriate permissions" do
        include_context "an authorized user"
        include_context 'it creates any tracking call'

        before do
          allow(Mako::EmotePrefix).to receive(:set_prefix).once
            .with(channel_id, prefix, state).and_return(double(persisted?: true))
          expect(Mako::EmotePrefix).to receive(:set_prefix).once

          post :update, params: {
            id: channel_id,
            mako_emote_prefix: {
              channel_id: channel_id,
              prefix: prefix,
              state: state
            }
          }
        end

        it_behaves_like 'it redirects the user and does not display an error'
      end

      context "a user without appropriate permissions" do
        include_context "an unauthorized user"

        before do
          post :update, params: {
            id: channel_id,
            mako_emote_prefix: {
              channel_id: channel_id,
              prefix: prefix,
              state: state
            }
          }
        end

        it_behaves_like "it redirects the user and displays an error"
      end
    end
  end
end
