require 'rails_helper'

describe TrackingController do
  describe 'heartbeat' do
    context 'a logged in user' do
      include_context 'mocked permissions'

      let(:params) { {:duration => '5'} }

      it 'should send a pageview heartbeat event to spade' do
        expect_any_instance_of(Faraday::Connection).to receive(:post).and_return(:status => 204, :body => "", :headers => {})
        post :heartbeat
      end
    end
    context 'a logged out user' do
      before do
        post :heartbeat
      end

      it_behaves_like 'it returns an unauthorized error response'
    end
  end
end
