require 'rails_helper'

RSpec.describe Transactions::EntriesController do
  include_context 'mocked permissions'
  describe 'index' do
    let(:permission) { ['transactions_search'] }
    let(:resp) { Code::Justin::Tv::Commerce::Paydayrpc::SearchTransactionsResp.new }

    context 'a user with appropriate permissions' do
      include_context 'an authorized user'

      context 'get event subtypes call to payday succeeds' do
        context 'makes no search call to payday on empty form' do
          before do
            expect(Transactions::Entry).not_to receive(:search)
            get :index
          end

          it_behaves_like 'it returns a success response'
        end

        context 'makes search call to payday succeeds' do
          before do
            expect(Transactions::Entry).to receive(:search).and_return(:resp)
            get :index, :params => { :event_search_type => "ONSITE" }
          end

          it_behaves_like 'it returns a success response'
        end
      end
    end

    context 'a user without permission' do
      include_context 'an unauthorized user'

      before do
        get :index
      end

      it_behaves_like 'it redirects the user and displays an error'
    end
  end
end

