require 'rails_helper'

module Twitch
  RSpec.describe AccountsController do
    include_context 'mocked permissions'

    describe '#reset' do
      let(:permission) { any_permission_in('users', 'twitch_user:update_details') }

      context "with an authorized user" do
        include_context 'an authorized user acting on a twitch user'

        context "with successful service calls" do
          include_context 'it creates any tracking call'

          let(:user) { Twitch::User.new }

          before do
            allow(Twitch::User).to receive(:find).with('foo').and_return(user)
            allow(user).to receive(:delete_all_authorizations).and_return(true)
            allow(user).to receive(:delete_all_cookies).and_return(true)
            allow(user).to receive(:disconnect_chat_sessions).and_return(true)
            allow(user).to receive(:force_password_reset).and_return(true)
            post :reset, params: { user_id: 'foo' }
          end

          it_behaves_like 'it redirects the user and displays a success message'
        end

        context "with an unsuccessful service call" do
          let(:user) { Twitch::User.new }

          before do
            allow(Twitch::User).to receive(:find).with('foo').and_return(user)
            allow(user).to receive(:delete_all_authorizations).and_return(true)
            allow(user).to receive(:delete_all_cookies).and_return(true)
            allow(user).to receive(:disconnect_chat_sessions).and_return(false)
            allow(user).to receive(:force_password_reset).and_return(true)
            post :reset, params: { user_id: 'foo' }
          end

          it_behaves_like 'it redirects the user and displays an error'
        end
      end

      context "with a user that does not exist" do
        before do
          allow(Twitch::User).to receive(:find).with('foo').and_return(nil)
          post :reset, params: { user_id: 'foo' }
        end

        it_behaves_like 'it redirects the user and displays an error'
      end

      context "with an unauthorized user" do
        let(:user) { Twitch::User.new }
        include_context 'an unauthorized user acting on a twitch user'

        before do
          allow(Twitch::User).to receive(:find).with('foo').and_return(user)
          post :reset, params: { user_id: 'foo' }
        end

        it_behaves_like 'it redirects the user and displays an error'
      end

    end
  end
end
