require 'rails_helper'

module Twitch
  RSpec.describe AdminsController do
    include_context 'mocked permissions'

    describe '#index' do
      let(:permission) { 'users' }
      include_context 'an authorized user'

      before do
        allow(GlobalPrivilegedUsers).to receive(:get).and_return(
          admins: ['zelda', 'samus', 'mario'],
          subadmins: ['foo', 'bar'],
          global_mods: ['suz', 'frank'],
        )
      end

      it 'sets the admins, subadmins, and global_mods in alphabetical order' do
        get :index
        expect(@controller.view_assigns['admins']).to eq(['mario', 'samus', 'zelda'])
        expect(@controller.view_assigns['subadmins']).to eq(['bar', 'foo'])
        expect(@controller.view_assigns['global_mods']).to eq(['frank', 'suz'])
      end

      it 'sets the number of admins, subadmins, and global_mods' do
        get :index
        expect(@controller.view_assigns['num_admins']).to eq(3)
        expect(@controller.view_assigns['num_subadmins']).to eq(2)
        expect(@controller.view_assigns['num_global_mods']).to eq(2)
      end
    end
  end
end
