require 'rails_helper'
require_relative './shared_contexts'

describe Twitch::OauthController do
  include_context 'mocked permissions'
  include_context 'with example twitch users'

  let(:permission) { any_permission_in('users', 'twitch_user:update_details') }
  let(:user) { twitch_user }

  describe 'delete_all_authorizations' do
    let(:action) { :delete_all_authorizations }
    let(:params) { { user_id: twitch_user_id } }

    before(:each) do
      expect(Twitch::User)
        .to receive(:find)
        .with(twitch_user_id)
        .and_return(twitch_user)
    end

    context 'a user with appropriate permissions' do
      include_context 'an authorized user acting on a twitch user'
      include_context 'it creates any tracking call'

      before(:each) do
        expect(twitch_user)
          .to receive(:delete_all_authorizations)
          .and_return(true)
        post action, params: params
      end

      it_behaves_like 'it redirects the user and displays a success message'
    end

    context 'a user without appropriate permissions' do
      include_context 'an unauthorized user acting on a twitch user'

      before(:each) do
        post action, params: params
      end

      it_behaves_like 'it redirects the user and displays an error'
    end
  end
end
