require 'rails_helper'

RSpec.describe Twitch::ReportClipsController do
  include_context 'mocked permissions'

  let(:permission) { 'aegis_report_clip_write' }

  describe 'remove report clips' do
    let(:user) { Twitch::User.new(displayname: "foo", id: "1234") }
    let(:audit) do
      History::Audit.new(
        action: "delete_report_clips",
        user_type: "ldap_user",
        user_id: "cool_ldap_login",
        resource_type: "report_clips",
        resource_id: user.id
      )
    end

    context 'an admin with appropriate permissions' do
      include_context 'an authorized user'

      before do
        allow(SupportTools::AegisGateway).to receive(:report_clip_count).with(anything).and_return({ count: 2 })
        expect(History::AddAudit).to receive(:add).with(audit)
        expect(DeleteReportClipsJob).to receive(:create).once.and_return({ id: 123 })
        delete :destroy, params: { user_id: user.id }
      end

      it_behaves_like 'it redirects the user and does not display an error'
    end

    context 'an admin without appropriate permissions' do
      include_context 'an unauthorized user'

      before { delete :destroy, params: { user_id: user.id } }

      it_behaves_like 'it redirects the user and displays an error'
    end
  end
end
