shared_context 'with example twitch users' do
  let(:twitch_user_id) { 'my-user-id' }
  let(:twitch_user_login) { 'my-user-login' }
  let(:twitch_user_email) { 'my-user-email' }
  let(:twitch_user_remote_ip) { 'my-user-remote-ip' }
  let(:twitch_user_created_on) { 'my-user-created-on' }
  let(:twitch_user_last_login) { 'my-user-last-login' }
  let(:twitch_user) do
    Twitch::User.new(
      id: twitch_user_id,
      login: twitch_user_login,
      email: twitch_user_email,
      remote_ip: twitch_user_remote_ip,
      created_on: twitch_user_created_on,
      last_login: twitch_user_last_login
    )
  end

  def fake_delete_response(success)
    Faraday::Response.new.tap do |response|
      allow(response)
        .to receive(:success?)
        .and_return(success)
    end
  end
end
