require 'rails_helper'

describe Twitch::TeamMembersController do
  include_context 'mocked permissions'

  let(:user) { Twitch::User.new(id: 123, login: 'kappa') }

  describe '#index' do
    let(:permission) { 'users' }

    let(:team) do
      Twitch::Team.new(
        id: '1',
        name: 'staff',
        display_name: 'Staff',
        description_markdown: '# Markdown'
      )
    end

    let(:membership) do
      Twitch::TeamMembership.new(
        team_id: team.id,
        channel_id: user.id.to_s,
        revenue_revealed: false,
        stats_revealed: true
      )
    end

    context 'when the team is not found' do
      before do
        allow(Twitch::Team).to receive(:find_by_name).with(team.name).and_return(nil)

        get :index, params: { team_name: team.name }
      end

      it_behaves_like 'it redirects the user and displays an error'
    end

    context 'when the team is found' do
      before do
        allow(Twitch::Team).to receive(:find_by_name).with(team.name).and_return(team)
        allow(Twitch::TeamMembership).to receive(:where).with({ team_id: team.id }).and_return([membership])
        allow(Twitch::User).to receive(:all).with(where: { id: [user.id.to_s] }, per_page: 1).and_return([user])

        get :index, params: { team_name: team.name }
      end

      it_behaves_like 'it returns a success response'
    end
  end
end
