require 'rails_helper'
require_relative './shared_contexts'

describe Twitch::TwoFactorController do
  include_context 'mocked permissions'
  include_context 'with example twitch users'

  describe 'disable' do
    let(:permission) { any_permission_in('users', 'twitch_user:update_details') }
    let(:params) { { user_id: twitch_user_id } }
    let(:user) { twitch_user }

    context 'two factor disable passes and sends audit' do
      before(:each) do
        Passport::TwoFactor.stub(:disable_2fa).and_return(true)
        post :disable_2fa, params: params
        expect(History::AddAudit).to receive(:add)
      end
    end

    context 'two factor disable fails and doesnt send an audit' do
      before(:each) do
        Passport::TwoFactor.stub(:disable_2fa).and_return(false)
        post :disable_2fa, params: params
        expect(History::AddAudit).to_not receive(:add)
      end
    end
  end
end
