require 'rails_helper'

describe Twitch::UserChannelPropertiesController do
  include_context 'mocked permissions'

  let(:permission) { any_permission_in('users', 'twitch:update_channel_properties') }
  let(:user_id) { '123' }
  let(:user) { Twitch::User.new(id: user_id) }
  let(:item) { Twitch::UserChannelProperty.new }

  describe 'edit' do
    let(:action) { :edit }

    context 'a user with appropriate permissions' do
      before(:each) do
        expect(Twitch::UserChannelProperty).to receive(:find).with(user_id).and_return(item)
      end

      context 'lookup success' do
        include_context 'an authorized user acting on a twitch user'

        before(:each) do
          allow(item).to receive(:user).and_return(user)
          get action, params: { user_id: user_id }
        end

        it_behaves_like 'it returns a success response'
      end

      context 'on user lookup error' do
        let(:item) { Twitch::UserChannelProperty.from_errors(['my-error']) }

        before(:each) do
          get action, params: { user_id: user_id }
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end
  end
end
