require 'rails_helper'

RSpec.describe VodAppeals::AppealsController do

  include_context 'mocked permissions'

  let(:permission) { 'vod_appeals' }

  describe 'index' do
    describe 'permissions' do
      let(:action) { :index }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Vods::VodAppeal).to receive(:all).and_return([])
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

  describe 'resolve' do
    describe 'permissions' do
      let(:action) { :resolve }
      let(:vod_id) { "112233" }
      let(:appeal) { Mocks.vod_appeal }

      context 'a user with appropriate permissions' do
        include_context 'it creates any tracking call'
        include_context 'an authorized user'
        let(:success_response) { Twirp::ClientResp.new(nil, nil) }

        before do
          expect(Vods::VodAppeal).to receive(:find).with(appeal.id).and_return(appeal)
          expect(appeal).to receive(:resolve).and_return(success_response)
          post action, params: {id: appeal.id, vod_id: vod_id}
        end

        it_behaves_like 'it redirects the user and displays a success message'
      end

      context 'a user with appropriate permissions with warning' do
        include_context 'an authorized user'
        let(:failed_response) { Twirp::ClientResp.new(nil, Twirp::Error.new(:internal, "some error")) }

        before do
          expect(Vods::VodAppeal).to receive(:find).with(appeal.id).and_return(appeal)
          expect(appeal).to receive(:resolve).and_return(failed_response)
          post action, params: {id: appeal.id, vod_id: vod_id}
        end

        it_behaves_like 'it redirects the user and displays a warning message'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          post action, params: {id: appeal.id, vod_id: vod_id}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end
end
