require 'rails_helper'

RSpec.describe Vods::ChannelsController do

  include_context 'mocked permissions'

  let(:permission) { 'users' }

  describe 'index' do
    describe 'permissions' do
      let(:action) { :index }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'

        before do
          expect(Vods::Channel).to receive(:find_for_user).and_return([])
          get action
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        let(:permission) { ['users', 'vods'] }
        include_context 'an unauthorized user'

        before do
          get action
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end

end
