require 'rails_helper'

RSpec.describe Vods::TrackAppealsController do

  include_context 'mocked permissions'

  let(:permission) { 'vod_appeals' }

  describe 'resolve' do
    describe 'permissions' do
      let(:id) { 'foo' }
      let(:action) { :resolve }
      let(:appeal_action) { "approve" }
      let(:dummy_item) { Vods::Vod.new }
      let(:appeal) { Vods::TrackAppeal.from_attributes(id: id) }

      context 'a user with appropriate permissions' do
        include_context 'an authorized user'
        include_context 'it creates any tracking call'

        before do
          expect(Vods::Vod).to receive(:find).with('bar').and_return(dummy_item)
          expect(dummy_item).to receive(:audible_magic_responses).and_return([])
          expect(Vods::TrackAppeal).to receive(:find).with(id).and_return(appeal)
          expect(appeal).to receive(:resolve).with(appeal_action)
          post action, :params => {id: id, vod_id: 'bar', format: 'js', appeal_action: appeal_action}
        end

        it_behaves_like 'it returns a success response'
      end

      context 'a user without appropriate permissions' do
        include_context 'an unauthorized user'

        before do
          post action, :params => {id: id}
        end

        it_behaves_like 'it redirects the user and displays an error'
      end
    end

  end
end
