require "rails_helper"

module Zuma
  describe Zuma::IsBlockingController do
    include_context "mocked permissions"

    let(:permission) { "user_block" }
    let(:user_id) { 123 }
    let(:blocked_user_id) { 456 }
    let(:is_blocked) { true }
    let(:initial_user_block) { Zuma::UserBlock.new(:id => user_id, :is_blocked => is_blocked) }

    describe "index" do
      describe "permissions" do
        context "a logged-in user viewing the index" do
          before do
            get :index
          end

          it_behaves_like "it returns a success response"
        end

        context "a logged-in user searching the block relation between two users" do
          before do
            expect(Zuma::UserBlock).to receive(:find).with(123, 456).and_return(initial_user_block)
            expect(Twitch::User).to receive(:find).with("123").and_return(Twitch::User.new(:id => user_id))
            expect(Twitch::User).to receive(:find).with("456").and_return(Twitch::User.new(:id => blocked_user_id))
            get :index, params: { user: "123", blocked_user: "456" }
          end

          it_behaves_like "it returns a success response"
        end

        context "a logged-in user searching another user's blocks by username" do
          before do
            expect(Zuma::UserBlock).to receive(:find).with(123, 456).and_return(initial_user_block)
            expect(Twitch::User).to receive(:find_by_login).with("user123").and_return(Twitch::User.new(:id => user_id))
            expect(Twitch::User).to receive(:find_by_login).with("user456").and_return(Twitch::User.new(:id => blocked_user_id))
            get :index, params: { user: "user123", blocked_user: "user456" }
          end

          it_behaves_like "it returns a success response"
        end
      end
    end
  end
end
