require "rails_helper"

module Zuma
  describe Zuma::UserBlocksController do
    include_context "mocked permissions"

    let(:permission) { "user_block" }
    let(:user_block_id) { 123 }
    let(:blocked_user_ids) { [345, 678] }
    let(:initial_user_block) { Zuma::UserBlock.new(:id => user_block_id, :blocked_user_ids => blocked_user_ids) }

    describe "index" do
      describe "permissions" do
        context "a logged-in user viewing the index" do
          before do
            get :index
          end

          it_behaves_like "it returns a success response"
        end

        context "a logged-in user searching another user's blocks by ID" do
          before do
            expect(Zuma::UserBlock).to receive(:all).with(123).and_return(initial_user_block)
            expect(Twitch::User).to receive(:find).with("123").and_return(Twitch::User.new(:id => user_block_id))
            expect(Twitch::User).to receive(:find).with(345).and_return(Twitch::User.new(:id => 345))
            expect(Twitch::User).to receive(:find).with(678).and_return(Twitch::User.new(:id => 678))
            get :index, params: { user: "123"}
          end

          it_behaves_like "it returns a success response"
        end

        context "a logged-in user searching another user's blocks by username" do
          before do
            expect(Zuma::UserBlock).to receive(:all).with(123).and_return(initial_user_block)
            expect(Twitch::User).to receive(:find_by_login).with("user123").and_return(Twitch::User.new(:id => user_block_id))
            expect(Twitch::User).to receive(:find).with(345).and_return(Twitch::User.new(:id => 345))
            expect(Twitch::User).to receive(:find).with(678).and_return(Twitch::User.new(:id => 678))
            get :index, params: { user: "user123"}
          end

          it_behaves_like "it returns a success response"
        end
      end
    end
  end
end
