require 'spec_helper'

feature '=== History Audit Search;', :type => :feature do

  def setup
    visit '/'
    sign_in

    should_see 'Audits'

    click_link 'Audits'

    expect(page).to have_current_path(history_query_audits_path)
  end

  def search(tuid)
    should_see 'Filter'

    within('form') do
      fill_in 'search_resource_type', :with => 'twitch_user'
      fill_in 'search_resource_id', :with => tuid

      click_button 'Filter'
    end
  end

  describe 'A user searches for audits,' do

    context "on a resource that should have audits," do
      given(:tuid) { 20037 }

      it "and finds audits." do
        setup
        search tuid
        should_see 'audit_source: => audits.rake'
      end

      pending "and sees flag tooltips." do
        setup
        search tuid
        first('.flag-holder').hover
        should_see "San Francisco"
      end
    end

    context "on a resource that should _not_ have audits," do
      given(:tuid) { 20038 }

      it "and does not find audits." do
        setup
        search tuid
        should_not_see('audit_source: => audits.rake')
      end
    end
  end
end
