require 'spec_helper'

feature '=== Ip Resolver;', :type => :feature do

  def setup
    visit '/'
    sign_in

    should_see 'IP Resolver'

    click_link 'IP Resolver'

    expect(page).to have_current_path(tools_ip_resolver_show_path)
  end

  def search(ip_text)
    should_see 'Ip addresses'
    should_see 'Submit'
    within('form') do

      fill_in 'Ip addresses', :with => ip_text

      click_button 'Submit'
    end
  end

  describe 'A user resolves geoIP info,' do

    context "with five valid input IPs," do
      given(:ip_text) do
        <<~HEREDOC
          64.125.35.114
          127.0.0.1
          64.125.35.114
          64.125.35.114
          64.125.35.114
        HEREDOC
      end

      it "and sees five returned rows" do
        setup
        search ip_text
        within('tbody') do
          expect(page.all('tr').count).to eq(5)
          should_see 'California'
        end
      end

      pending "and sees flag tooltips." do
        setup
        search ip_text
        first('.flag-holder').hover
        should_see "United States"
      end
    end

    context "with five valid IPs and one invalid IP," do
      given(:ip_text) do
        <<~HEREDOC
          64.125.35.114
          127.0.0.1
          256.105.190.149 # invalid
          64.125.35.114
          64.125.35.114
          64.125.35.114
        HEREDOC
      end

      it "and sees five returned rows." do
        setup
        search ip_text
        within('tbody') do
          expect(page.all('tr').count).to eq(5)
          should_see 'California'
        end
      end

      it "and does not see an invalid IP." do
        setup
        search ip_text
        should_not_see "256.105.190.149"
      end
    end
  end
end
