require 'spec_helper'

feature '=== Translation Tool;', :type => :feature do

  def setup
    visit '/'
    sign_in

    should_see 'Translation Tool'

    click_link 'Translation Tool'

    expect(page).to have_current_path(tools_translator_root_path)
  end

  def translate(from_lang, to_lang, text)
    should_see 'Detect Language'
    should_see 'Translate'
    within('form') do

      select from_lang, from: "from"
      select to_lang, from: "to"
      fill_in 'text', with: text

      click_button 'Translate'
    end
  end

  describe 'A user translates an input text,' do

    context "with a known english string," do

      given(:from) do
        "English"
      end
      given(:to) do
        "Spanish (Mexico)"
      end
      given(:text) do
        <<~HEREDOC
          hello
        HEREDOC
      end

      it "and sees a known-correct translation" do
        setup
        translate from, to, text
        should_see 'hola'
        should_see from, within: "from"
        should_see to, within: "to"
      end

    end

    context "with a known but non-english string," do

      given(:from) do
        "Detect Language"
      end
      given(:to) do
        "Spanish (Mexico)"
      end
      given(:text) do
        <<~HEREDOC
          quarta-feira meus amigos
        HEREDOC
      end

      it "and sees a known-correct translation" do
        setup
        translate from, to, text
        should_see 'Miércoles mis amigos'
        should_see to, within: "to"
      end

      it 'and sees the from language flagged as auto-detected' do
        setup
        translate from, to, text
        should_see 'Detected: Portuguese', within: "from"
      end

    end
  end
end
