require 'rails_helper'

describe BeefCake::AttachedPermissionHelper do
  include BeefCake::AttachedPermissionHelper

  describe('to_scope_s') do
    let(:attached_permission) do
      BeefCake::AttachedPermission.from_attributes(scope: scope)
    end

    before(:each) do
      expect(to_scope_s(attached_permission)).to eq(expected)
    end

    context('no scope') do
      let(:scope) { [] }
      let(:expected) { 'Full Access' }

      it 'succeeds' do
      end
    end

    context('with scope') do
      let(:scope) do
        [
          Twitch::Fulton::Beefcake::PermissionScope.new(
            channel_payout: Twitch::Fulton::Beefcake::PermissionScope::ChannelPayoutType::AFFILIATE
          ),
          Twitch::Fulton::Beefcake::PermissionScope.new(
            channel_payout: Twitch::Fulton::Beefcake::PermissionScope::ChannelPayoutType::PARTNER
          )
        ]
      end
      let(:expected) { 'Affiliate, Partner' }

      it 'succeeds' do
      end
    end
  end
end
