require 'rails_helper'

class Helper
  include Bits::BadgesHelper
end

RSpec.describe Bits::BadgesHelper do
  let(:helper) { Helper.new }
  let(:custom_badge) do
    {
      "title" => "a custom title",
      "threshold" => 1000,
      "image_url_1x" => "some url",
      "image_url_2x" => "some_url",
      "image_url_4x" => "some_url"
    }
  end
  let(:default_badge) do
    {
      "title" => "cheer 1000 ",
      "threshold" => 1000,
      "image_url_1x" => "default_url",
      "image_url_2x" => "default_url",
      "image_url_4x" => "default_url"
    }
  end
  let(:default_badges) do
    {
      "versions" => {
        "1000" => default_badge
      }
    }
  end

  before(:each) do
    helper.instance_variable_set(:@default_badges, default_badges)
  end

  describe 'custom_badge_title?' do
    it 'returns true for a badge with custom title' do
      expect(helper.custom_badge_title?(custom_badge)).to eql(true)
    end

    it 'returns false for a badge with default title' do
      expect(helper.custom_badge_title?(default_badge)).to eql(false)
    end

    it 'returns true if a corresponding default badge is not found' do
      default_badge['threshold'] = 12345
      expect(helper.custom_badge_title?(default_badge)).to eql(true)
    end
  end

  describe 'custom_badge_images?' do
    it 'returns true for a badge with custom images' do
      expect(helper.custom_badge_images?(custom_badge)).to eql(true)
    end

    it 'returns false for a badge with default images' do
      expect(helper.custom_badge_images?(default_badge)).to eql(false)
    end

    it 'returns true if a corresponding default badge is not found' do
      default_badge['threshold'] = 12345
      expect(helper.custom_badge_images?(default_badge)).to eql(true)
    end
  end
end