require 'rails_helper'

class Helper
  include RevenueReporting::PayoutDetailHelper
end

RSpec.describe RevenueReporting::PayoutDetailHelper do
  let(:helper) { Helper.new }

  describe 'display_month' do
    it 'returns name of month' do
      expect(helper.display_month(1)).to eql('January')
    end

    it 'returns nil' do
      expect(helper.display_month(nil)).to eql(nil)
    end
  end

  describe 'display_price' do
    it 'formatted price USD' do
      expect(helper.display_price(100, 'USD')).to eql('$1.00 USD')
    end

    it 'formatted price EUR' do
      expect(helper.display_price(100, 'EUR')).to eql('€1.00 EUR')
    end

    it 'formatted price JPY' do
      expect(helper.display_price(100, 'JPY')).to eql('¥100 JPY')
    end

    it 'formatted price zero' do
      expect(helper.display_price(0, 'JPY')).to eql('¥0 JPY')
    end

    it 'formatted price nil' do
      expect(helper.display_price(nil, 'USD')).to eql(nil)
    end
  end
end