describe BaseJob do
  describe 'linear_retry' do
    let(:job) { described_class.new('foo') }

    it 'retries until success' do
      ntry = 0
      func = proc do
        ntry += 1
        raise 'MyError' if ntry < 30
        'done'
      end

      expect(job.linear_retry(func, rate: 0)).to eq('done')
    end

    it 'it raises last error' do
      func = proc { raise 'MyError' }
      expect {job.linear_retry(func, rate: 0)}.to raise_error('MyError')
    end
  end
end
