describe DeleteReportClipsJob do
  describe 'perform' do
    let(:options) { {} }
    let(:job) { described_class.new('foo', options) }
    let(:userid) { 123 }

    context "delete calls succeed" do
      let(:options) { { "user_id" => userid } }

      before do
        expect(SupportTools::AegisGateway).to receive(:delete_report_clips_by_user).with({
          user_id: userid,
          limit: 100,
          cursor: nil
        }).and_return({
          "page_info" => {
            "next_cursor" => "next-cursor"
          }
        }).once
        expect(SupportTools::AegisGateway).to receive(:delete_report_clips_by_user).with({
          user_id: userid,
          limit: 100,
          cursor: "next-cursor"
        }).and_return({
          "page_info" => {
            "next_cursor" => ""
          }
        }).once
      end

      it 'succeeds' do
        expect(job).to receive(:at).with(1, 2, "deleting").once
        expect(job).to receive(:completed).once
        job.perform
      end
    end

    context 'delete call fails' do
      let(:options) { { "user_id" => userid } }

      before do
        expect(SupportTools::AegisGateway).to receive(:delete_report_clips_by_user).with({
          user_id: userid,
          limit: 100,
          cursor: nil
        }).and_return({}).once
      end

      it 'reports error' do
        expect(job).to receive(:set_status).once
        job.perform
      end
    end
  end
end
