require "rails_helper"

describe ForcePasswordResetJob do 
  
  describe '#perform' do 
    it 'resets the password for all provided users' do
      logins = ['samus', 'peach']
      
      samus_id = '1111'
      samus_user = Twitch::User.new
      peach_id = '2222'
      peach_user = Twitch::User.new
      
      allow(samus_user).to receive(:fetch_id).and_return(samus_id)
      allow(Twitch::User).to receive(:new).with(login: 'samus').and_return(samus_user)
      
      allow(peach_user).to receive(:fetch_id).and_return(peach_id)
      allow(Twitch::User).to receive(:new).with(login: 'peach').and_return(peach_user)
      
      job = ForcePasswordResetJob.new("foo", "users" => logins)
      allow(Passport::Passwords).to receive(:force_reset).and_return(true)
      job.perform
      expect(Passport::Passwords).to have_received(:force_reset).with(samus_id)
      expect(Passport::Passwords).to have_received(:force_reset).with(peach_id)
    end
  end
end
