describe TOSJob do
  describe 'perform' do
    let(:options) { {} }
    let(:job) { described_class.new('foo', options) }
    let(:userid) { 'my-user-id' }
    let(:user) { Twitch::User.new(login: userid) }
    let(:response) { double "yay" }
    let(:audit) do
      History::Audit.new(
        action: "ban_user",
        user_type: "ldap_user",
        user_id: nil,
        resource_type: "twitch_user",
        resource_id: userid,
        description: nil,
        changes: []
      )
    end

    before(:each) do
      allow(Twitch::User).to receive(:new).with(login: userid).and_return(user)
    end

    describe 'while banning' do
      let(:options) { { 'job_type' => 'tos_ban', 'users' => [userid] } }
      let(:is_partner) { false }
      let(:is_affiliate) { false }
      let(:mock_response) do
        Code::Justin::Tv::Revenue::Ripley::PayoutType.new(
          channel_id: userid,
          is_partner: is_partner,
          is_affiliate: is_affiliate
        )
      end
      let(:ripley_response) { {userid.to_s => mock_response} }

      before do
        expect(user).to receive(:fetch_id).and_return(userid)
        expect(Ripley::BatchGetPayoutType).to receive(:call).with([userid]).and_return(ripley_response)
      end

      context "ban call succeeds" do
        before do
          expect(user).to receive(:tos_ban).and_return(true)
        end

        it 'succeeds' do
          expect(job).to receive(:at).with(1, 1, 'Banning my-user-id')
          job.perform
        end
      end

      context "ban call fails" do
        before do
          expect(user).to receive(:tos_ban).and_return(false)
        end

        it 'reports failure' do
          expect(job).to receive(:at).with(1, 1, 'Banning my-user-id')
          expect(job).to receive(:set_status)
            .with(error_message: 'Failed to ban my-user-id')
          job.perform
        end
      end

      it 'suspends and records audit' do
        expect(job).to receive(:at).with(1, 1, 'Banning my-user-id')
        allow(Twitch::User).to receive(:find).and_return(user)
        allow(user).to receive(:fetch_id).and_return(userid)
        allow(SupportTools::AegisGateway).to receive(:post).and_return(response)
        expect(History::AddAudit).to receive(:add).with(audit)
        allow(response).to receive(:success?).and_return(true)

        job.perform
      end
    end

    describe 'while unbanning' do
      let(:options) { { 'job_type' => 'tos_unban', 'users' => [userid] } }

      it 'succeeds' do
        expect(job).to receive(:at).with(1, 1, 'Unbanning my-user-id')
        expect(user).to receive(:tos_unban).and_return(true)
        job.perform
      end

      it 'reports failure' do
        expect(job).to receive(:at).with(1, 1, 'Unbanning my-user-id')
        expect(user).to receive(:tos_unban)
          .and_return(false)
        expect(job).to receive(:set_status)
          .with(error_message: 'Failed to unban my-user-id')
        job.perform
      end
    end
  end
end
