require 'rails_helper'

describe IpGeo do
  describe '.from_maxmind' do
    context 'with valid inputs' do
      let(:geo_lookup) do
        MaxMindDB::Result.new({'city' => {'geoname_id' => 1789897, 'names' => {'en' => 'Zijinglu', 'zh-CN' => '紫荆路'}},
                               'continent' =>
                               {'code' => 'AS',
                                'geoname_id' => 6255147,
                                'names' =>
                                   {'de' => 'Asien',
                                    'en' => 'Asia',
                                    'es' => 'Asia',
                                    'fr' => 'Asie',
                                    'ja' => 'アジア',
                                    'pt-BR' => 'Ásia',
                                    'ru' => 'Азия',
                                    'zh-CN' => '亚洲'}},
                               'country' =>
                                {'geoname_id' => 1814991,
                                 'iso_code' => 'CN',
                                 'names' =>
                                   {'de' => 'China',
                                    'en' => 'China',
                                    'es' => 'China',
                                    'fr' => 'Chine',
                                    'ja' => '中国',
                                    'pt-BR' => 'China',
                                    'ru' => 'Китай',
                                    'zh-CN' => '中国'}},
                               'location' =>
                                 {'accuracy_radius' => 50,
                                  'latitude' => 34.76,
                                  'longitude' => 112.9714,
                                  'time_zone' => 'Asia/Shanghai'},
                               'registered_country' =>
                                 {'geoname_id' => 1814991,
                                  'iso_code' => 'CN',
                                  'names' =>
                                    {'de' => 'China',
                                     'en' => 'China',
                                     'es' => 'China',
                                     'fr' => 'Chine',
                                     'ja' => '中国',
                                     'pt-BR' => 'China',
                                     'ru' => 'Китай',
                                     'zh-CN' => '中国'}},
                               'subdivisions' =>
                                 [{'geoname_id' => 1808520,
                                   'iso_code' => 'HA',
                                   'names' => {'en' => 'Henan', 'fr' => 'Province de Henan', 'zh-CN' => '河南'}}],
                               'network' => '39.150.128.0/17'})
      end
      let(:isp_lookup) { MaxMindDB::Result.new({'autonomous_system_number' => 9808, 'autonomous_system_organization' => 'Guangdong Mobile Communication Co.Ltd.', 'isp' => 'China Mobile Guangdong', 'organization' => 'China Mobile Guangdong', 'network' => '39.144.0.0/13'}) }

      it 'extracts the expected fields' do
        geo = IpGeo.from_maxmind(geo_lookup, isp_lookup)
        expect(geo.country).to eq 'China'
        expect(geo.region).to eq 'Henan'
        expect(geo.city).to eq 'Zijinglu'
        expect(geo.isp).to eq 'China Mobile Guangdong'
        expect(geo.country_code).to eq 'CN'
        expect(geo.accuracy_radius).to eq 50
        expect(geo.latitude).to eq 34.76
        expect(geo.longitude).to eq 112.9714
      end
    end
  end
end