module ResqueJobs
  describe Worker do
    let(:pid) { 'my-pid' }
    let(:id) { 'my-id' }
    let(:hostname) { 'my-hostname' }
    let(:job_id) { 'my-job-id' }
    let(:job) { { 'payload' => { 'args': [job_id] } } }
    let(:queue) { 'derp' }

    describe 'all' do
      let(:resque_worker) do
        w = Resque::Worker.new(queue)
        allow(w).to receive(:id).and_return(id)
        allow(w).to receive(:pid).and_return(pid)
        allow(w).to receive(:hostname).and_return(hostname)
        allow(w).to receive(:job).and_return(job)
        w
      end

      it 'fetches all workers' do
        expect(Resque::Worker).to receive(:all)
          .and_return([resque_worker])
        objects = described_class.all
        expect(objects.length).to eq(1)
        expect(objects[0].id).to eq(id)
        expect(objects[0].hostname).to eq(hostname)
        expect(objects[0].job).to eq(job)
      end
    end

    describe 'job_id' do
      it 'returns a job id' do
        id = 'my-id'
        worker = Worker.new(job: { 'payload' => { 'args' => [id] }})
        expect(worker.job_id).to eq(id)
      end

      it 'return nil on no job' do
        worker = Worker.new
        expect(worker.job_id).to eq(nil)
      end
    end

    context 'with an existing job_status' do
      let(:job_id) { 'my-job-id' }
      let(:t_time) { Time.new.change(sec: 0, minute: 0) }
      let(:status) { 'my-status' }
      let(:hash_status) do
        hs = Resque::Plugins::Status::Hash.new
        hs.time = t_time.to_i
        hs.status = status
        hs
      end

      before(:each) do
        @worker = Worker.new(job: { 'payload' => { 'args' => [job_id] } })
        expect(hash_status.status).to eq('my-status')
        expect(Resque::Plugins::Status::Hash).to receive(:get)
          .and_return(hash_status)
      end

      describe 'status' do
        it 'returns non-nil' do
          expect(@worker.status).to eq(status)
        end
      end

      describe 'job_started' do
        it 'returns non-nil' do
          expect(@worker.job_started).to eq(t_time)
        end
      end
    end
  end
end
