module Secrets
  describe SandstormLoader do
    describe 'load_from_sandstorm' do
      let(:sandstorm) { double('sandstorm') }
      let(:duo_skey) { 'my-duo-skey' }
      let(:client_id) { 'my-client-id' }
      let(:client_secret) { 'my-client-secret' }
      let(:password_jwt_secret) { 'my-password-jwt-secret' }
      let(:rollbar_token) { 'my-rollbark-token' }
      let(:secret_token) { 'my-secret-token' }

      before(:each) do
        allow(described_class).to receive(:client).and_return(sandstorm)
        [
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/chaos.sentry.client_id", client_id],
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/chaos.sentry.client_secret", client_secret],
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/duo.skey", duo_skey],
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/openid.client_id", client_id],
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/openid.client_secret", client_secret],
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/password_jwt_secret", password_jwt_secret],
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/rollbar_token", rollbar_token],
          ["web-rails/admin-panel/#{Settings.sandstorm_env}/secret_token", secret_token]
        ].each do |key, value|
          allow(sandstorm).to receive(:get_decrypted_secret)
            .with(Code::Justin::Tv::Sse::Sandstorm::GetDecryptedSecretReq.new(name: key))
            .and_return(
              Twirp::ClientResp.new(
                Code::Justin::Tv::Sse::Sandstorm::GetDecryptedSecretRes.new(plaintext: value),
                nil
              )
            )
        end
      end

      it 'returns the correct format' do
        expect(described_class.load_from_sandstorm).to eq(
          'chaos' => { 'sentry' => { 'client_id' => client_id, 'client_secret' => client_secret } },
          'duo' => { 'skey' => duo_skey },
          'openid' => { 'client_id' => client_id, 'client_secret' => client_secret },
          'passport' => { 'jwt_secret' => password_jwt_secret },
          'rollbar_token' => rollbar_token,
          'secret_token' => secret_token
        )
      end
    end
  end
end
