require 'rails_helper'

describe SpadeClient do
  describe '.send_event' do
    context 'an event with valid properties' do
      let(:properties) { {:event => 'fake_event', :foo => 'bar'} }
      let(:encoded_properties) { {:data => "eyJldmVudCI6ImZha2VfZXZlbnQiLCJwcm9wZXJ0aWVzIjp7ImZvbyI6ImJh\nciJ9fQ==\n"} }

      it 'sends a correctly encoded payload' do
        expect_any_instance_of(Faraday::Connection).to receive(:post).with('/track', encoded_properties).and_return(:status => 204, :body => "", :headers => {})

        SpadeClient.send_event(properties)
      end
    end

    context 'an event that triggers an error' do
      let(:properties) { {:event => 'fake_event', :foo => 'bar'} }

      it 'does not propagate the exception to the caller' do
        expect_any_instance_of(Faraday::Connection).to receive(:post).and_raise(Faraday::TimeoutError)

        expect {SpadeClient.send_event(properties)}.not_to raise_error
      end
    end
  end
end
