module Mocks
  def self.twitch_user(attributes = {})
    klass = Twitch::User
    missing_attributes = attributes.keys - klass.attribute_names
    raise "#{klass.name} does not have these attributes: #{missing_attributes.join(', ')}" if missing_attributes.present?

    user = klass.new attributes
    user.id ||= "123456"

    user
  end

  def self.vod_appeal(attributes = {})
    klass = Vods::VodAppeal
    missing_attributes = attributes.keys - klass.attribute_names
    raise "#{klass.name} does not have these attributes: #{missing_attributes.join(', ')}" if missing_attributes.present?

    appeal = klass.new attributes
    appeal.vod_appeal_id ||= "123456"

    appeal
  end

  def self.vodapi_vod(attributes = {})
    options = {
      id: "123456",
      owner_id: "7890",
      broadcast_type: :HIGHLIGHT,
      broadcast_id: "111",
      status: :RECORDED,
    }.merge(attributes)

    Vodapi::Vod.new options
  end

  def self.vod(attributes = {})
    klass = Vods::Vod
    missing_attributes = attributes.keys - klass.attribute_names
    raise "#{klass.name} does not have these attributes: #{missing_attributes.join(', ')}" if missing_attributes.present?

    vod = klass.new attributes
    vod.id ||= "123456"

    vod
  end

  def self.vod_audible_magic_response(attributes = {})
    klass = Vods::AudibleMagicResponse
    missing_attributes = attributes.keys - klass.attribute_names
    raise "#{klass.name} does not have these attributes: #{missing_attributes.join(', ')}" if missing_attributes.present?

    amr = klass.new attributes
    amr.id ||= "111"

    amr
  end
end
