module ServiceHelper

  def fake_delete_response(success)
    http_response = Faraday::Response.new
    allow(http_response)
      .to receive(:success?)
            .and_return(success)
    Service::Response.new(http_response)
  end

  def fake_get_response(status_code, body = nil)
    http_response = Faraday::Response.new
    allow(http_response)
      .to receive(:status)
            .and_return(status_code)
    Service::Response.new(http_response).tap do |response|
      allow(response)
        .to receive(:body)
              .and_return(body)
    end
  end

  shared_context 'with s2s2' do
    before(:each) do
      allow_any_instance_of(Service::S2S).to receive(:credentials).and_return(nil)
    end
  end
end
