require 'rails_helper'

RSpec.describe Badges::Bits do
  include ServiceHelper

  describe 'global_display' do
    describe 'on success service call' do
      let(:badge_versions) {{'versions' => {}}}
      let(:response) do
        Faraday::Response.new.tap do |response|
          allow(response).to receive(:success?).and_return(true)
          allow(response).to receive(:status).and_return(200)
          allow(response).to receive(:body).and_return({
            'badge_sets' => {
              'bits' => badge_versions
            }
          })
        end
      end

      it 'retrieves all default bits badges' do
        allow(Badges::Base).to receive(:get).and_return(response)
        expect(Badges::Bits.global_display).to eql(badge_versions)
      end
    end

    describe 'on failed service call' do
      let(:response) do
        Faraday::Response.new.tap do |response|
          allow(response).to receive(:success?).and_return(false)
        end
      end

      it 'returns empty on failure' do
        allow(Badges::Base).to receive(:get).and_return(response)
        expect(Badges::Bits.global_display).to eql({})
      end
    end
  end
end