require_relative '../../service_helper'

module BeefCake
  describe Health do
    include ServiceHelper

    describe 'status - success' do
      let(:beefcake_success_response) do
        res = fake_get_response(200)
        expect(res).to receive(:success?).and_return(true)
        res
      end

      before(:each) do
        expect(described_class).to receive(:get)
          .with("/ping")
          .and_return(beefcake_success_response)
      end

      it 'returns successful status' do
        expect(described_class.status).to eql(true)
      end
    end
  end
end
