require 'rails_helper'
require_relative './helpers'
require_relative './shared_contexts'
require 'shared_examples_for_twirp_services'

module BeefCake
  describe Membership do
    include_context 'with example memberships'

    describe('find') do
      let(:method) { -> { described_class.find(id) } }
      let(:twirp_method) { :get_role }
      let(:twirp_request) do
        Twitch::Fulton::Beefcake::GetRoleRequest.new(id: role_id)
      end
      let(:twirp_data) { twirp_role }
      let(:expected) { membership }

      it_behaves_like 'a twirp backed service'
    end

    describe('save') do
      let(:method) { -> { membership.save } }
      let(:twirp_method) { :add_user_to_role }
      let(:twirp_request) do
        Twitch::Fulton::Beefcake::AddUserToRoleRequest.new(
          role_id: role_id,
          user_id: member_user_id,
          membership_expiration: member_expires_at_twirp
        )
      end
      let(:twirp_data) { nil }
      let(:expected) { true }

      it_behaves_like 'a twirp backed service'
    end

    describe('destroy') do
      let(:method) { -> { membership.destroy } }
      let(:twirp_method) { :remove_user_from_role }
      let(:twirp_request) do
        Twitch::Fulton::Beefcake::RemoveUserFromRoleRequest.new(
          role_id: role_id,
          user_id: member_user_id
        )
      end
      let(:twirp_data) { nil }
      let(:expected) { true }

      it_behaves_like 'a twirp backed service'
    end

    describe('realm_user') do
      it 'returns the realm user' do
        expect(membership.realm_user).to eq(TwitchLDAPRealmUser.from_attributes(
                                              realm: Realm::TWITCH_LDAP,
                                              id: membership.uid
        ))
      end
    end
  end
end
