require_relative './helpers'

module BeefCake
  describe Permission do
    include_context 'with example permissions'

    describe('all') do
      let(:method) { -> { described_class.all } }
      let(:twirp_method) { :get_legacy_permissions }
      let(:twirp_request) do
        Twitch::Fulton::Beefcake::GetLegacyPermissionsRequest.new
      end
      let(:twirp_data) do
        res = Twitch::Fulton::Beefcake::GetLegacyPermissionsResponse.new
        res.legacy_permissions.replace([
                                         Twitch::Fulton::Beefcake::GetLegacyPermissionsResponse::LegacyPermission.new(
                                           id: perm_id,
                                           name: perm_name,
                                           description: perm_description
                                         )
                                       ])
        res
      end
      let(:expected) do
        [BeefCake::Permission.new(
          id: perm_id,
          canonical_name: perm_id,
          description: perm_description,
          name: perm_name
        )]
      end

      it_behaves_like 'a twirp backed service'
    end

    describe('find') do
      let(:method) { -> { described_class.find(perm_id) } }
      let(:twirp_method) { :get_legacy_permission }
      let(:twirp_request) do
        Twitch::Fulton::Beefcake::GetLegacyPermissionRequest.new(id: perm_id)
      end
      let(:twirp_data) { twirp_permission }
      let(:expected) { permission }

      it_behaves_like 'a twirp backed service'
    end

    describe('save') do
      context('is persisted') do
        let(:method) { -> { persist(permission).save } }
        let(:twirp_method) { :update_legacy_permission }
        let(:twirp_request) do
          Twitch::Fulton::Beefcake::UpdateLegacyPermissionRequest.new(
            id: perm_id,
            name: Google::Protobuf::StringValue.new(value: perm_name),
            description: Google::Protobuf::StringValue.new(value: perm_description)
          )
        end
        let(:twirp_data) { twirp_permission }
        let(:expected) { true }

        it_behaves_like 'a twirp backed service'
      end

      context('is not persisted') do
        let(:perm_canonical_name) { 'my-perm-canonical-name' }
        let(:form_permission) do
          p = permission
          p.canonical_name = perm_canonical_name
          p
        end
        let(:method) { -> { form_permission.save } }
        let(:twirp_method) { :create_legacy_permission }
        let(:twirp_request) do
          Twitch::Fulton::Beefcake::CreateLegacyPermissionRequest.new(
            id: perm_canonical_name,
            name: perm_name,
            description: perm_description
          )
        end
        let(:twirp_data) { twirp_permission }
        let(:expected) { true }

        it_behaves_like 'a twirp backed service'
      end
    end

    describe('destroy') do
      let(:method) { -> { permission.destroy } }
      let(:twirp_method) { :delete_legacy_permission }
      let(:twirp_request) do
        Twitch::Fulton::Beefcake::DeleteLegacyPermissionRequest.new(
          id: perm_id
        )
      end
      let(:twirp_data) { twirp_permission }
      let(:expected) { true }

      it_behaves_like 'a twirp backed service'
    end
  end
end
