describe BeefCake::RealmUser do
  describe 'from_uri' do
    let(:id) { 'ID' }

    shared_examples 'builds the expected realm user' do
      it 'builds the expected realm user' do
        result = described_class.from_uri(uri)
        expect(result).to eq(expected)
        expect(result.uri).to eq(uri)
      end
    end

    context 'with a titan support uri' do
      let(:realm) { BeefCake::Realm::TITAN_SUPPORT }
      let(:expected) { BeefCake::TitanRealmUser.new(realm: realm, id: id) }
      let(:uri) { "titan:#{id}" }
      it_behaves_like 'builds the expected realm user'
    end

    context 'with a twitch uri' do
      let(:realm) { BeefCake::Realm::TWITCH_LDAP }
      let(:expected) { BeefCake::TwitchLDAPRealmUser.new(realm: realm, id: id) }
      let(:uri) { id }
      it_behaves_like 'builds the expected realm user'
    end
  end

  describe 'twitch_ldap_user?' do
    it 'returns false for titan support' do
      expect(described_class.from_uri('titan:id').twitch_ldap_user?).to eq(false)
    end

    it 'returns true for twitch legacy' do
      expect(described_class.from_uri('id').twitch_ldap_user?).to eq(true)
    end
  end
end

describe BeefCake::TwitchLDAPRealmUser do
  let(:id) { 'myid' }
  let(:user) { described_class.from_uri(id) }

  before(:each) do
    expect(Guardian::User).to receive(:find).with(id).and_return(guardian_user)
  end

  shared_examples 'a looked up validation' do
    it 'valid? checks guardian' do
      expect(user.valid?).to be(expected)
    end
  end

  describe 'valid?' do
    context 'with a valid guardian id' do
      let(:guardian_user) { Guardian::User.from_attributes(ldap_login: id) }
      let(:expected) { true }
      it_behaves_like 'a looked up validation'
    end

    context 'with an invalid guardian id' do
      let(:guardian_user) { nil }
      let(:expected) { false }
      it_behaves_like 'a looked up validation'
    end
  end
end

describe BeefCake::TitanRealmUser do
  describe 'valid?' do
    it 'returns true for a support email' do
      user = described_class.from_uri('titan:me@support.titan.xarth.tv')
      expect(user.valid?).to be(true)
    end

    it 'returns true for a safety email' do
      user = described_class.from_uri('titan:me@safety.titan.xarth.tv')
      expect(user.valid?).to be(true)
    end

    it 'returns false for an invalid email' do
      user = described_class.from_uri('titan:me@jank.com')
      expect(user.valid?).to be(false)
    end
  end
end
