require 'rails_helper'

RSpec.describe Bits::Actual do
  include ServiceHelper

  describe "all" do
    let(:twirp_response) do
      data = Code::Justin::Tv::Commerce::Pachter::GetActualsResp.new
      data.actuals = Google::Protobuf::Map.new(:string, :uint32)
      data.actuals['bit-type-2'] = 2
      data.actuals['bit-type-1'] = 1
      Twirp::ClientResp.new(data, nil)
    end

    before(:each) do
      expect(described_class.twirp_client).to(receive(:get_actuals)).and_return(twirp_response)
    end

    it 'retrieves all actuals' do
      actuals = described_class.all(11, 2019, 'IOS')
      expect(actuals.size).to eq(2)
      expect(actuals[0]).to eq(['bit-type-1', 1])
      expect(actuals[1]).to eq(['bit-type-2', 2])
    end
  end

  describe "platforms" do
    it 'retrieves all platforms (except NONE) as strings' do
      platforms = described_class.platforms
      expect(platforms.size).to be > 1
      expect(platforms.include?("NONE")).to be false
    end
  end

  describe "configure" do

    describe "when client succeeds" do
      let(:twirp_response) do
        data = Code::Justin::Tv::Commerce::Pachter::SetActualsResp.new
        Twirp::ClientResp.new(data, nil)
      end
      before(:each) do
        expect(described_class.twirp_client).to(receive(:set_actuals)).and_return(twirp_response)
      end

      it "returns true if save succeeds" do
        expect(described_class.configure(11, 2019, 'IOS', { 'bit-type-1' => 1})).to eq(true)
      end
    end
  end

end
