require 'rails_helper'

module DartReceiver
  describe DartReceiver::Notification do
    include ServiceHelper

    let(:notification_type) { "best_notification" }
    let(:email) { "best_email@twitch.tv" }
    let(:locale) { "en" }
    let(:metadata) {{"key" => "value"}}

    describe 'publish_notification' do
      let(:publish_notification_response) do
        double(
          error: error,
          data: data
        )
      end

      let(:params) do
        Receiver::PublishNotificationRequest.new(
          notification_type: notification_type,
          recipient_email_address_with_locale: Receiver::RecipientEmailAddressWithLocale.new(email: email, locale: locale),
          metadata: metadata
        )
      end

      subject { described_class.publish_notification_to_email_address_with_locale(notification_type, email, locale, metadata) }

      context 'with error receiver response' do

        let(:error) { double(msg: 'failed something') }
        let(:data) {{}}

        it 'should raise error' do
          expect_any_instance_of(::Receiver::ReceiverClient).to receive(:publish_notification).with(params).and_return(publish_notification_response)
          expect {subject}.to raise_error(error.msg)
        end
      end

      context 'with successful receiver response' do

        let(:error) { nil }
        let(:data) { Receiver::PublishNotificationResponse.new(notification_trace_id: "123") }

        it 'should not raise error' do
          expect_any_instance_of(::Receiver::ReceiverClient).to receive(:publish_notification).with(params).and_return(publish_notification_response)
          expect {subject}.not_to raise_error
        end
      end
    end
  end
end
