require "rails_helper"

describe Games::AddCategory do
  include ServiceHelper

  describe "save" do
    let(:add_category) do
      Games::AddCategory.from_attributes(igdb_id: "igdb-id-123")
    end

    let(:invalid_add_category) do
      Games::AddCategory.from_attributes(igdb_id: "")
    end

    let(:twirp_response) do
      data = Twitchcategoryindexer::SyncIGDBCategoryResponse.new(
        categoryID: 123
      )
      Twirp::ClientResp.new(data, nil)
    end

    let(:twirp_error) do
      Twirp::ClientResp.new(nil, Twirp::Error.new(:internal, "some error", {}))
    end

    context "success" do
      it "sync-category-success" do
        expect(described_class.twirp_client).to(receive(:sync_i_g_d_b_category)).and_return(twirp_response)
        response = add_category.save
        expect(response.categoryID).to eq(123)
      end
    end

    context "service-error" do
      it "sync-category-failure" do
        expect(described_class.twirp_client).to(receive(:sync_i_g_d_b_category)).and_return(raise_error)
        expect { add_category.save }.to raise_error
      end
    end

    context "client-error" do
      it "argument-error" do
        expect { invalid_add_category.save }.to raise_error
      end
    end
  end
end
