require 'rails_helper'

RSpec.describe Games::AddCategoryTag, type: :service do
  context "#save" do
    let(:tag) { Games::AddCategoryTag.from_attributes(ldap_login: "someguy", game_id: "game id", game_name: "game name", tag_id: "tag id", tag_nam: "tag name")}
    let(:invalid_tag1) { Games::AddCategoryTag.from_attributes(ldap_login: "someguy", game_name: "game name", tag_id: "tag id", tag_nam: "tag name")}
    let(:invalid_tag2) { Games::AddCategoryTag.from_attributes(ldap_login: "someguy", game_id: "game id", game_name: "game name", tag_nam: "tag name")}
    let(:invalid_tag3) { Games::AddCategoryTag.from_attributes(ldap_login: "someguy", game_name: "game name", tag_nam: "tag name")}
    let(:response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(true)
        allow(response).to receive(:body).and_return(
          "tag" => {
            "id" => "test id"
          }
        )
      end
    end
    let(:create_tag_expected_url) { Games::AddCategoryTag::GRAFFITI_ENDPOINT + Games::AddCategoryTag::SERVICE_NAMESPACE + "/CreateContentTags" }
    let(:create_tag_expected_body) {'{"content_id":"game id","tag_ids":["tag id"],"content_type":"CATEGORY","modifier_id":"someguy"}'}
    let(:create_tag_expected_headers) { { 'Content-Type' => 'application/json' } }

    let(:error_response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(false)
        allow(response).to receive(:body).and_return(
          "msg" => "anime was a mistake"
        )
      end
    end

    it 'update invalid params' do
      expect(invalid_tag1.save).to eq(false)
      expect(invalid_tag2.save).to eq(false)
      expect(invalid_tag3.save).to eq(false)
    end
    it 'update success' do
      expect(Games::AddCategoryTag).to receive(:post).with(create_tag_expected_url, { headers: create_tag_expected_headers, body: create_tag_expected_body }).and_return(response)
      expect(tag.save).to eq(true)
    end

    it 'update grafffiti error' do
      expect(Games::AddCategoryTag).to receive(:post).with(create_tag_expected_url, { headers: create_tag_expected_headers, body: create_tag_expected_body }).and_return(error_response)
      expect(tag.save).to eq(false)
    end
  end
end
