require 'rails_helper'

RSpec.describe Graffiti::CreateTag, type: :service do
  context "#save" do
    let(:tag) { Graffiti::CreateTag.from_attributes(ldap_login: "someguy", name: "test name", localize: "0", tag_scope: "SCOPE_CATEGORY", internal: "true", restricted: "true", persistent: "false")}
    let(:response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(true)
        allow(response).to receive(:body).and_return(
          "tag" => {
            "id" => "test id"
          }
        )
      end
    end
    let(:create_tag_expected_url) { '/twirp/code.justin.tv.discovery.graffiti.rpc.graffiti.Graffiti/CreateTag' }
    let(:create_tag_expected_body) {'{"name":"test name","tag_scope":"SCOPE_CATEGORY","modifier_id":"someguy","description":null,"internal":true,"restricted":true,"persistent":false}'}
    let(:create_tag_expected_headers) { { 'Content-Type' => 'application/json' } }

    let(:error_response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(false)
        allow(response).to receive(:body).and_return(
          "msg" => "anime was a mistake"
        )
      end
    end
    let(:tag_with_localize) { Graffiti::CreateTag.from_attributes(ldap_login: "someguy", name: "test name", localize: "1", tag_scope: "SCOPE_CATEGORY", internal: "true", restricted: "true", persistent: "false", instruction: "stop watching anime")}
    let(:create_task_expected_url) { '/twirp/code.justin.tv.discovery.graffiti.rpc.graffitilocalization.GraffitiLocalization/CreateTagLocalizationTask' }
    let(:create_task_expected_body) {'{"id":"test id","instruction":"stop watching anime"}'}
    let(:create_task_expected_headers) { { 'Content-Type' => 'application/json' } }

    it 'update no localize success' do
      expect(Graffiti::CreateTag).to receive(:post).with(create_tag_expected_url, { headers: create_tag_expected_headers, body: create_tag_expected_body }).and_return(response)
      expect(tag.save).to eq(true)
    end
    it 'update no localize graffiti tag error' do
      expect(Graffiti::CreateTag).to receive(:post).with(create_tag_expected_url, { headers: create_tag_expected_headers, body: create_tag_expected_body}).and_return(error_response)
      expect(tag.save).to eq(false)
    end
    it 'update with localize success' do
      expect(Graffiti::CreateTag).to receive(:post).with(create_tag_expected_url, { headers: create_tag_expected_headers, body: create_tag_expected_body }).and_return(response)
      expect(Graffiti::CreateTag).to receive(:post).with(create_task_expected_url, { headers: create_task_expected_headers, body: create_task_expected_body }).and_return(response)
      expect(tag_with_localize.save).to eq(true)
    end
    it 'update with localize graffiti task failure' do
      expect(Graffiti::CreateTag).to receive(:post).with(create_tag_expected_url, { headers: create_tag_expected_headers, body: create_tag_expected_body }).and_return(response)
      expect(Graffiti::CreateTag).to receive(:post).with(create_task_expected_url, { headers: create_task_expected_headers, body: create_task_expected_body }).and_return(error_response)
      expect(tag_with_localize.save).to eq(false)
    end

  end
end
