require 'rails_helper'

RSpec.describe Graffiti::EditTag, type: :service do

  context "#update" do
    let(:tag) { Graffiti::EditTag.from_attributes(ldap_login: "someguy", state: "APPROVED", scope: "SCOPE_UNSET", internal: "true", bg_bg: "bg bg")}
    let(:tag_with_localize) { Graffiti::EditTag.from_attributes(ldap_login: "someguy", state: "APPROVED", localize: "1", scope: "SCOPE_UNSET", internal: "true", bg_bg: "bg bg")}
    let(:response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(true)
      end
    end
    let(:expected_url) { '/twirp/code.justin.tv.discovery.graffiti.rpc.graffiti.Graffiti/UpdateTag' }
    let(:create_task_expected_url) { '/twirp/code.justin.tv.discovery.graffiti.rpc.graffitilocalization.GraffitiLocalization/CreateTagLocalizationTask' }
    let(:expected_body) {'{"id":null,"modifier_id":"someguy","state":"APPROVED","tag_scope":"SCOPE_UNSET","internal":true,"localizations":{"bg-bg":"bg bg"},"description_localizations":{},"ipr_set":true}'}
    let(:create_task_expected_body) {'{"id":null,"instruction":""}'}
    let(:expected_headers) { { 'Content-Type' => 'application/json' } }
    let(:error_response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(false)
        allow(response).to receive(:body).and_return(
          "msg" => "anime was a mistake"
        )
      end
    end
    it 'update success' do
      expect(Graffiti::EditTag).to receive(:post).with(expected_url, { body: expected_body, headers: expected_headers }).and_return(response)
      expect(tag.save).to eq(true)
    end
    it 'update graffiti error' do
      expect(Graffiti::EditTag).to receive(:post).with(expected_url, { body: expected_body, headers: expected_headers }).and_return(error_response)
      expect(tag.save).to eq(false)
    end
    it 'update success with localize' do
      expect(Graffiti::EditTag).to receive(:post).with(expected_url, { body: expected_body, headers: expected_headers }).and_return(error_response)
      expect(Graffiti::EditTag).to receive(:post).with(create_task_expected_url, { body: create_task_expected_body, headers: expected_headers }).and_return(response)
      expect(tag_with_localize.save).to eq(false)
    end
  end

  context "#find" do
    let(:response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(true)
        allow(response).to receive(:body).and_return(
          "tag" => {
            "id" => "test id",
            "name" => "test name",
            "state" => "APPROVED",
            "tag_scope" => "SCOPE_UNSET",
            "internal" => true,
            "localizations" => {
              "bg-bg" => "bad game"
            }
          }
        )
      end
    end
    let(:expected_url) { '/twirp/code.justin.tv.discovery.graffiti.rpc.graffiti.Graffiti/GetTag' }
    let(:expected_body) {'{"id":"test id"}'}
    let(:expected_headers) { { 'Content-Type' => 'application/json' } }
    let(:error_response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(false)
        allow(response).to receive(:body).and_return(
          "msg" => "harry potter"
        )
      end
    end
    it 'find success' do
      expect(Graffiti::EditTag).to receive(:post).with(expected_url, { body: expected_body, headers: expected_headers }).and_return(response)
      expect(Graffiti::EditTag.find("test id")).to have_attributes(
        id: "test id",
        name: "test name",
        state: "APPROVED",
        scope: "SCOPE_UNSET",
        internal: true,
        bg_bg: "bad game"
      )
    end
    it 'find graffiti error' do
      expect(Graffiti::EditTag).to receive(:post).with(expected_url, { body: expected_body, headers: expected_headers }).and_return(error_response)
      expect(Graffiti::EditTag.find("test id").errors.full_messages).to eq(["harry potter"])
    end
  end
end
