require "rails_helper"

module Guardian
  describe User do
    describe 'find' do
      let(:test_user) {"test_user"}
      let(:invalid_user) {"invalid_user"}
      let(:users) { [test_user, invalid_user]}

      let(:response) do
        Faraday::Response.new.tap do |response|
          allow(response).to receive(:body).and_return({
             "data" => {
              "attributes" => {
                "cn" => "Test User",
                "uid" => "test_user",
                "email" => "test_user@twitch.tv"
              }
            }
          })
          allow(response).to receive(:success?).and_return(true)
        end
      end

      let(:not_found_response) do
        Faraday::Response.new.tap do |response|
          allow(response).to receive(:body).and_return(
            {
             "errors" => [{
               "title" => "Not Found",
               "status" => "404",
              }],
            }
          )
          allow(response).to receive(:success?).and_return(true)
        end
      end

      before do
        users.each do |user|
        end
      end

      it 'return user data' do

        expect(Base).to receive(:get)
          .with("/ldap/users/test_user").and_return(response)
        user = User.find(test_user)
        expect(user).not_to be_nil
        expect(user.ldap_login).to eq(test_user)
        expect(user.email).not_to be_nil
      end

      it 'return user not found' do
        expect(Base).to receive(:get)
          .with("/ldap/users/invalid_user").and_return(not_found_response)
        user = User.find(invalid_user)
        expect(user).to be_nil
      end
    end
  end
end
