require 'rails_helper'
require 'twirp'

module History
  describe GDPRBase do
    let(:resp) do
      Twirp::ClientResp.new(
        Class.new do
          def self.items
            []
          end
        end,
        nil
      )
    end
    let(:requester) { "my-ldap" }
    let(:user_id) { "user-id" }
    let(:deletion_time) { Google::Protobuf::Timestamp.new(seconds: Time.parse("02/08/2019 3:34 PM").to_i) }

    it 'should respond to list_reports' do
      expect(History::Report.gdpr_client).to receive(:list_reports)
        .with(requester: requester)
        .and_return(resp)
      History::Report.list_reports(requester: requester)
    end

    context 'get_user_stats' do
      let(:resp) do
        Twirp::ClientResp.new(
          Class.new do
            def self.recordCount # rubocop:disable Naming/MethodName
              10
            end
          end,
          nil
        )
      end
      it 'should respond to get_user_stats' do
        expect(History::Deletion.gdpr_client).to receive(:get_user_stats)
          .with({ :user_id => user_id })
          .and_return(resp)
        History::Deletion.get_user_stats(user_id)
      end
    end

    it 'should respond to list_scheduled_deletions' do
      expect(History::Deletion.gdpr_client).to receive(:list_scheduled_deletes)
        .with(requester: requester)
        .and_return(resp)
      History::Deletion.list_scheduled_deletions(requester: requester)
    end

    it 'should respond to request_reports' do
      expect(History::Report.gdpr_client).to receive(:request_report)
        .with(
          requester: requester,
          user_id: user_id
        )
        .and_return(resp)
      History::Report.request_report(user_id, requester)
    end

    it 'should respond to request_deletion' do
      expect(History::Deletion.gdpr_client).to receive(:delete_audits)
        .with(
          user_id: user_id,
          requester: requester,
          deletion_time: deletion_time
        )
        .and_return(resp)
      History::Deletion.request_deletion(user_id, requester, deletion_time)
    end
  end
end
